;------------------------------------------------------------------------------
; Used constants:
;
; C_LOCALTOSCREEN = local to screen matrix
; C_LOCALTOWORLD  = local to world matrix
; C_CAMERAPOS     = camera position vector
;
; Computing spherical environment mapping:
; 1. Computation of the reflection vector R:
;    R = E - 2 * (N * Nt) * E     with E = eye position
;                                      N = normal and Nt = normal transposed
;
; 2. Computation of the U, V coordinates:
;    S = 2 * sqrt(Rx^2 + Ry^2 + (Rz + 1)^2)
;    U = Rx / S + 0.5
;    V = Ry / S + 0.5
;------------------------------------------------------------------------------
xvs.1.1

#include "ShadersConst.h"

#define V_POS      v0   ; position
#define V_COLOR    v1   ; color
#define V_NORM     v2   ; normal
#define V_TEX1     v3   ; tex1
#define V_TEX2     v4   ; tex2
#define V_TEX3     v5   ; tex3
#define V_TEX4     v6   ; tex4

; Calculate r0 = E - 2 * (N * Nt) * E
mul r0, V_NORM.yzxw, V_NORM.zxyw
mad r0, -V_NORM.yzxw, V_NORM.zxyw, r0
mul r1, r0.yzxw, c[C_CAMERAPOS].zxyw
mad r1, -c[C_CAMERAPOS].yzxw, r0.zxyw, r1
mul r1, r1, -C_TWO
add r0, c[C_CAMERAPOS], r1

; Calculate r1 = 2 * sqrt(r0.x^2 + r0.y^2 + (r0.z + 1)^2)
add r0.z, r0.z, C_ONE
dp3 r1, r0, r0
rsq r1.x, r0.x         ; r1.x = 2 * sqrt(r1.x)
mul r1.x, r1.x, r0.x
mul r1.x, r1.x, C_TWO

; r2.x = r0.x / r1.x + 0.5
; r2.y = r0.y / r1.x + 0.5
rcp r2.xy, r1.x
mul r2.xy, r0.xy, r2.xy
add r2.xy, r2.xy, C_HALF

; Transform the vertex to camera space
mul r0, c[C_LOCALTOSCREEN+0], V_POS.x
mad r0, c[C_LOCALTOSCREEN+1], V_POS.y, r0
mad r0, c[C_LOCALTOSCREEN+2], V_POS.z, r0
mad r0, c[C_LOCALTOSCREEN+3], V_POS.w, r0
mov oPos, r0

mov	oD0,    V_COLOR
mov oT0.xy, V_TEX1
mov oT1.xy, V_TEX2
mov oT2.xy, r2.xy
mov oT3.xy, V_TEX4


;////////////////////////////////////////////////////////////////


/*
#define R_WORLDSPACE_NORMAL r9
#define R_WORLDSPACE_NORMAL_REFRACT r7
#define R_EYE_VECTOR r3
#define R_DOT2 r4 
#define R_TEMP r1 

; Transform position
dp4 oPos.x, V_POS, c[C_LOCALTOSCREEN+0]
dp4 oPos.y, V_POS, c[C_LOCALTOSCREEN+1]
dp4 oPos.z, V_POS, c[C_LOCALTOSCREEN+2]
dp4 oPos.w, V_POS, c[C_LOCALTOSCREEN+3]

; Get world space vertex position
dp4 r0.x, V_POS, c[C_LOCALTOWORLD+0]
dp4 r0.y, V_POS, c[C_LOCALTOWORLD+1]
dp4 r0.z, V_POS, c[C_LOCALTOWORLD+2]
dp4 r0.w, V_POS, c[C_LOCALTOWORLD+3]

; Transform normal to world space
dp3 R_WORLDSPACE_NORMAL.x, V_NORM, c[C_LOCALTOWORLD+0]
dp3 R_WORLDSPACE_NORMAL.y, V_NORM, c[C_LOCALTOWORLD+1]
dp3 R_WORLDSPACE_NORMAL.z, V_NORM, c[C_LOCALTOWORLD+2]

; Need to re-normalize normal
dp3 R_WORLDSPACE_NORMAL.w, R_WORLDSPACE_NORMAL, R_WORLDSPACE_NORMAL
rsq R_WORLDSPACE_NORMAL.w, R_WORLDSPACE_NORMAL.w
mul R_WORLDSPACE_NORMAL, R_WORLDSPACE_NORMAL, R_WORLDSPACE_NORMAL.w

; Get vector from eye to vertex
sub R_TEMP, r0, c[C_CAMERAPOS]
dp3 R_EYE_VECTOR.w, R_TEMP, R_TEMP
rsq R_EYE_VECTOR.w, R_EYE_VECTOR.w		
mul R_EYE_VECTOR, R_TEMP, R_EYE_VECTOR.w

; Calculate E - 2*(E dot N)*N 
dp3 R_DOT2, R_EYE_VECTOR, R_WORLDSPACE_NORMAL
add R_DOT2, R_DOT2, R_DOT2
mad r0.xyz,R_WORLDSPACE_NORMAL, -R_DOT2, R_EYE_VECTOR
mov r0.w, C_ONE

; Calculate r1 = 2 * sqrt(r0.x^2 + r0.y^2 + (r0.z + 1)^2)
add r0.z, r0.z, C_ONE
dp3 r1, r0, r0
rsq r1.x, r0.x         ; r1.x = 2 * sqrt(r1.x)
mul r1.x, r1.x, r0.x
mul r1.x, r1.x, C_TWO

; r2.x = r0.x / r1.x + 0.5
; r2.y = r0.y / r1.x + 0.5
rcp r2.xy, r1.x
mul r2.xy, r0.xy, r2.xy
add r2.xy, r2.xy, C_HALF

mov	oD0,    V_COLOR
mov oT0.xy, V_TEX1
mov oT1.xy, V_TEX2
mov oT2.xy, r2.xy
mov oT3.xy, V_TEX4
*/